/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.apple2e.SoftSwitches;
import jace.apple2e.softswitch.MemorySoftSwitch;
import jace.config.ConfigurableField;
import jace.core.Computer;
import jace.core.Device;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Joystick
extends Device {
    @ConfigurableField(name="Enabled")
    public boolean enabled;
    public int port;
    private int x = 0;
    private int y = 0;
    private int joyX = 0;
    private int joyY = 0;
    MemorySoftSwitch xSwitch;
    MemorySoftSwitch ySwitch;
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Point lastMouseLocation;
    Robot robot;
    RAMListener listener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

        protected void doConfig() {
            this.setScopeStart(49264);
            this.setScopeEnd(49279);
        }

        protected void doEvent(RAMEvent e) {
            Joystick.this.setRun(true);
            Joystick.this.readJoystick();
            if (Joystick.this.x <= 0) {
                Joystick.this.xSwitch.setState(true);
                Joystick.this.x = 10 + Joystick.this.joyX * 11;
            }
            if (Joystick.this.y <= 0) {
                Joystick.this.ySwitch.setState(true);
                Joystick.this.y = 10 + Joystick.this.joyY * 11;
            }
        }
    };

    public Joystick(int port) {
        this.port = port;
        if (port == 0) {
            this.xSwitch = (MemorySoftSwitch)SoftSwitches.PDL0.getSwitch();
            this.ySwitch = (MemorySoftSwitch)SoftSwitches.PDL1.getSwitch();
        } else {
            this.xSwitch = (MemorySoftSwitch)SoftSwitches.PDL2.getSwitch();
            this.ySwitch = (MemorySoftSwitch)SoftSwitches.PDL3.getSwitch();
        }
        this.lastMouseLocation = MouseInfo.getPointerInfo().getLocation();
        try {
            this.robot = new Robot();
        }
        catch (AWTException ex) {
            Logger.getLogger(Joystick.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readJoystick() {
        Point l = MouseInfo.getPointerInfo().getLocation();
        this.joyX = l.x < this.lastMouseLocation.x ? 0 : (l.x > this.lastMouseLocation.x ? 255 : 128);
        this.joyY = l.y < this.lastMouseLocation.y ? 0 : (l.y > this.lastMouseLocation.y ? 255 : 128);
        if (l.x == 0) {
            this.robot.mouseMove(10, l.y);
            l = MouseInfo.getPointerInfo().getLocation();
        }
        if ((double)(l.x + 1) == this.screenSize.getWidth()) {
            this.robot.mouseMove((int)(this.screenSize.getWidth() - 10.0), l.y);
            l = MouseInfo.getPointerInfo().getLocation();
        }
        if (l.y == 0) {
            this.robot.mouseMove(l.x, 10);
            l = MouseInfo.getPointerInfo().getLocation();
        }
        if ((double)(l.y + 1) == this.screenSize.getHeight()) {
            this.robot.mouseMove(l.x, (int)(this.screenSize.getHeight() - 10.0));
            l = MouseInfo.getPointerInfo().getLocation();
        }
        this.lastMouseLocation = l;
    }

    protected String getDeviceName() {
        return "Joystick (port " + this.port + ")";
    }

    public void tick() {
        boolean finished = true;
        if (this.x > 0) {
            if (--this.x == 0) {
                this.xSwitch.setState(false);
            } else {
                finished = false;
            }
        }
        if (this.y > 0) {
            if (--this.y == 0) {
                this.ySwitch.setState(false);
            } else {
                finished = false;
            }
        }
        if (finished) {
            this.setRun(false);
        }
    }

    public void attach() {
        this.registerListeners();
    }

    public void detach() {
        this.removeListeners();
    }

    public void reconfigure() {
        this.x = 0;
        this.y = 0;
        if (this.enabled) {
            this.registerListeners();
        } else {
            this.removeListeners();
        }
    }

    private void registerListeners() {
        Computer.getComputer().getMemory().addListener(this.listener);
    }

    private void removeListeners() {
        Computer.getComputer().getMemory().removeListener(this.listener);
    }
}

